Imports System.Threading

Public Class ThreadStaticDemo
  <ThreadStatic()> _
  Private Shared I As Integer = 0
  Private Count As Integer = 0

  Private Sub WriteCount()

    Console.WriteLine( _
      String.Format("Thread {0} added {1} to count", _
      Thread.CurrentThread.GetDomain.GetCurrentThreadId(), _
      Count))

  End Sub

  Public Sub Increment()

    While (Interlocked.Increment(I) < 1000000)
      Count += 1
    End While

    WriteCount()

  End Sub

  Public Shared Function Instance() As ThreadStaticDemo
    Return New ThreadStaticDemo()
  End Function

End Class


Module Module1


  Sub Main()

    Dim Threads(10) As Thread
    Dim I As Integer
    For I = 0 To Threads.Length - 1
      Threads(I) = New Thread( _
        AddressOf ThreadStaticDemo.Instance.Increment)

      Threads(I).IsBackground = True
      Threads(I).Start()
    Next

    For I = 0 To Threads.Length - 1
      Threads(I).Join()
    Next

    Console.ReadLine()

  End Sub

End Module
